DECLARE @DFName varchar(75);
DECLARE @DFDrop varchar(200);

IF EXISTS(SELECT 1 FROM syscolumns WHERE id = object_id('EST_PROD_PRECO_TBL_HIST_CPL') and name = 'PERC_ICMS')
BEGIN 
	DELETE
	FROM  
	 EST_PROD_PRECO_TBL_HIST_CPL
	WHERE ISNUMERIC(PERC_ICMS)=0;
END


IF EXISTS (SELECT * 
    FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS
    WHERE CONSTRAINT_NAME='PK_EST_PROD_PRECO_TBL_HIST_CPL')
BEGIN
	ALTER TABLE [dbo].[EST_PROD_PRECO_TBL_HIST_CPL] DROP CONSTRAINT [PK_EST_PROD_PRECO_TBL_HIST_CPL]
END


SET @DFName = (	SELECT A.name
				FROM 
					SYS.OBJECTS A
					JOIN SYS.OBJECTS B ON 
					A.parent_object_id = B.object_id 	
					JOIN SYS.sysconstraints  C ON 
					B.object_id = C.ID 
					AND  A.object_id =C.constid 

					JOIN syscolumns D ON
					D.colid = c.colid 
					AND B.object_id = D.id

					left join INFORMATION_SCHEMA.CHECK_CONSTRAINTS  e on 
					a.name = e.CONSTRAINT_NAME 
				WHERE
					B.NAME='EST_PROD_PRECO_TBL_HIST_CPL'
					AND A.TYPE IN( 'D', 'C')
					AND D.name ='PERC_ICMS')

SET @DFDrop = 'ALTER TABLE [dbo].[EST_PROD_PRECO_TBL_HIST_CPL] DROP CONSTRAINT '+ @DFName
					
IF EXISTS(SELECT 1 FROM syscolumns WHERE id = object_id('EST_PROD_PRECO_TBL_HIST_CPL') and name = 'PERC_ICMS')
BEGIN 
	EXEC (@DFDrop);
END

ALTER TABLE EST_PROD_PRECO_TBL_HIST_CPL ALTER COLUMN PERC_ICMS money NOT NULL

ALTER TABLE [dbo].[EST_PROD_PRECO_TBL_HIST_CPL] ADD  DEFAULT ('0') FOR [PERC_ICMS]

ALTER TABLE [dbo].[EST_PROD_PRECO_TBL_HIST_CPL] ADD  CONSTRAINT [PK_EST_PROD_PRECO_TBL_HIST_CPL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_CTR] ASC,
	[CD_PROD] ASC,
	[PERC_ICMS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]

